package com.cftech.common.approver.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 通用申请单审批人
 *
 * @author faye
 * @date: 2019-08-14 17:05
 */
@Data
public class Approver implements Serializable {

    /* 主键id */
    private Long id;
    /* 审批人姓名 */
    @ExportConfig(value = "审批人姓名", width = 100)
    private String name;
    /* 审批人邮箱 */
    @ExportConfig(value = "审批人邮箱", width = 100)
    private String email;
    /* 所属部门 */
    private Long department;
    @ExportConfig(value = "所属部门", width = 100)
    private String departmentName;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    @ExportConfig(value = "是否启用(0:禁用 1:启用)", width = 100)
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;
    /* 序号 */
    @ExportConfig(value = "排序值", width = 100)
    private Integer sort;

    private Long typeform;

    public Approver() {
        this.delFlag = false;
        this.status = "1";
    }

}