package com.cftech.base.codingrule.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.model.Codingrule;
import com.cftech.base.codingrule.service.CodingruleService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.core.util.StringUtils;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * 权限字符串说明:
 * 查看:public static final String CODINGRULE_VIEW = "qy:codingrule:view"
 * 查看:public static final String CODINGRULE_EDIT = "qy:codingrule:edit"
 * codingruleWeb
 * Created by Neil 16/02/2017.
 */
@Slf4j
@Controller
@RequestMapping("/a/codingrule")
public class CodingruleController {

    /**
     * codingruleService
     */
    @Autowired
    private CodingruleService codingruleService;

    //返回列表页面
    @RequiresPermissions(value = PermissionSign.CODINGRULE_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.POST,RequestMethod.GET})
    public String codingruleList(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "managercodingrule/codingrulelist";
    }

    //返回编辑页面（新增、修改）
    @RequiresPermissions(value = PermissionSign.CODINGRULE_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.POST,RequestMethod.GET})
    public String form(HttpServletRequest request, String id, Model model) {

        if (StringUtils.isNotBlank(id)) {
            Codingrule codingrule = codingruleService.fetchById(id);
            model.addAttribute("data", codingrule);
            model.addAttribute("accountId", codingrule.getAccountsId());
        } else {
            Long accountId = UserUtils.getmpaccounts(request);
            model.addAttribute("accountId", accountId);
        }
        return "managercodingrule/codingruleform";
    }

    //提交编辑页面（新增、修改）
    @RequiresPermissions(value = PermissionSign.CODINGRULE_EDIT)
    @RequestMapping(value = "/formData",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject codingruleListformData(Codingrule codingrule, Model model, HttpServletRequest request) {
        JSONObject rtnJson = new JSONObject();
        try {
            if (codingrule != null && codingrule.getId() != null) {
                codingrule.setUpdateBy(UserUtils.getUser().getId());
                codingruleService.update(codingrule);
                rtnJson.put("errorNo", 0);
            } else {
                codingrule.setDelFlag(false);
                codingrule.setAccountsId(UserUtils.getmpaccounts(request));
                codingrule.setCreateBy(UserUtils.getUser().getId());
                codingrule.setUpdateBy(UserUtils.getUser().getId());
                codingruleService.save(codingrule);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = PermissionSign.CODINGRULE_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.POST,RequestMethod.GET})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Codingrule codingrule, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (StringUtils.isNotBlank(codingrule.getName())) {
            conds.like("name", codingrule.getName());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);
        List<Codingrule> list = codingruleService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer userCounts = codingruleService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", userCounts);
        rtnJson.put("iTotalDisplayRecords", userCounts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = PermissionSign.CODINGRULE_EDIT)
    @RequestMapping(value = "/delete",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            codingruleService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping(value = "/exportExcel",method = {RequestMethod.POST,RequestMethod.GET})
    @RequiresPermissions(value = PermissionSign.CODINGRULE_EDIT)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        List<Codingrule> codingrules = codingruleService.fetchSearchByPage(conds, sort, 0, 0);

        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(Codingrule.class, response).toExcel(codingrules, "组织分类信息");
    }

    @RequestMapping(value = "/templateExcel",method = {RequestMethod.POST,RequestMethod.GET})
    @RequiresPermissions(value = PermissionSign.CODINGRULE_EDIT)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(Codingrule.class, response).toExcel(null, "组织分类信息");
    }

    @RequestMapping(value = "/importExcel",method = {RequestMethod.POST,RequestMethod.GET})
    @RequiresPermissions(value = PermissionSign.CODINGRULE_EDIT)
    public String importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        if (file == null) {
            return codingruleList(request, model);
        }
        // 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    Codingrule codingrule = new Codingrule();
                    codingrule.setAccountsId(accountId);
                    codingrule.setName(rowData.get(1));
                    codingruleService.save(codingrule);
                }

            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }


        return codingruleList(request, model);
    }
}