package com.cftech.cms.exhibi_vocation.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.cms.exhibi_read.model.Exhibi_read;
import com.cftech.cms.exhibi_read.model.Exhibi_readDto;
import com.cftech.cms.exhibi_vocation.model.Exhibi_vocation;
import com.cftech.cms.exhibi_vocation.model.Exhibi_vocationDto;
import com.cftech.cms.exhibi_vocation.service.Exhibi_vocationService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String EXHIBI_VOCATION_VIEW = "qy:exhibi_vocation:view"
 * 查看:public static final String EXHIBI_VOCATION_EDIT = "qy:exhibi_vocation:edit"
 *
 * @author byj
 * @date: 2018-09-12 15:56
 */
@Slf4j
@Controller
@RequestMapping("/a/exhibi_vocation")
public class Exhibi_vocationController {

    public static final String EXHIBI_VOCATION_VIEW = "qy:exhibi_vocation:view";
    public static final String EXHIBI_VOCATION_EDIT = "qy:exhibi_vocation:edit";

    @Autowired
    private Exhibi_vocationService exhibi_vocationService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = EXHIBI_VOCATION_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,String exhibi_id) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("exhibi_id",exhibi_id);
        return "exhibi_vocation/exhibi_vocationlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = EXHIBI_VOCATION_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Exhibi_vocation exhibi_vocation = exhibi_vocationService.fetchById(id);
            model.addAttribute("data", exhibi_vocation);
        }
        return "exhibi_vocation/exhibi_vocationform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = EXHIBI_VOCATION_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Exhibi_vocation exhibi_vocation, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (exhibi_vocation != null && exhibi_vocation.getId() != null) {
                exhibi_vocation.setUpdateBy(UserUtils.getUser().getId());
                exhibi_vocationService.update(exhibi_vocation);
                rtnJson.put("errorNo", 0);
            } else {
                exhibi_vocation.setNumber(codingruleUtils.getNumber(accountsId, Exhibi_vocation.class.getName()));
                exhibi_vocation.setAccountsId(accountsId);
                exhibi_vocation.setDelFlag(false);
                exhibi_vocation.setAccountsId(UserUtils.getmpaccounts(request));
                exhibi_vocation.setCreateBy(UserUtils.getUser().getId());
                exhibi_vocation.setUpdateBy(UserUtils.getUser().getId());
                exhibi_vocationService.save(exhibi_vocation);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = EXHIBI_VOCATION_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Exhibi_vocationDto exhibi_vocationDto, HttpServletRequest request,String exhibi_id) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("v.del_flag", Constants.DEL_FLAG_0);
        conds.equal("v.accounts_id", accountsId);
        conds.equal("f.delflag",0);
        if (!StringUtils.isEmpty(exhibi_vocationDto.getVocation())) {
            conds.like("v.vocation", exhibi_vocationDto.getVocation());
        }
        if(!StringUtils.isEmpty(exhibi_id)){
            conds.equal("v.exhibi_id",exhibi_id);
        }
        if(!StringUtils.isEmpty(exhibi_vocationDto.getNickname())){
            conds.like("f.nickname",exhibi_vocationDto.getNickname());
        }
        Sort sort = new Sort("v.create_time", OrderType.DESC);

        List<Exhibi_vocation> list = exhibi_vocationService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = exhibi_vocationService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value =  EXHIBI_VOCATION_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response,Exhibi_read exhibi_read, Exhibi_vocationDto exhibi_vocationDto,String exhibi_id) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("v.del_flag", Constants.DEL_FLAG_0);
        conds.equal("v.accounts_id", accountsId);
        conds.equal("f.delflag",0);
        if (!StringUtils.isEmpty(exhibi_vocationDto.getVocation())) {
            conds.like("v.vocation", exhibi_vocationDto.getVocation());
        }
        if(!StringUtils.isEmpty(exhibi_id)){
            conds.equal("v.exhibi_id",exhibi_id);
        }
        if(!StringUtils.isEmpty(exhibi_vocationDto.getNickname())){
            conds.like("f.nickname",exhibi_vocationDto.getNickname());
        }
        Sort sort = new Sort("v.create_time", OrderType.DESC);

        List<Exhibi_vocation> list = exhibi_vocationService.fetchSearchByPage(conds, sort, 0, 0);

        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(Exhibi_vocationDto.class, response).toExcel(list, "人员所属行业");
    }

    //删除数据
    @RequiresPermissions(value = EXHIBI_VOCATION_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            exhibi_vocationService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
