package com.cftech.workshop.welcome.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.workshop.welcome.model.Welcome;
import com.cftech.workshop.welcome.service.WelcomeService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String WELCOME_VIEW = "qy:welcome:view"
 * 查看:public static final String WELCOME_EDIT = "qy:welcome:edit"
 *
 * @author byj
 * @date: 2018-07-10 14:32
 */
@Slf4j
@Controller
@RequestMapping("/a/welcome")
public class WelcomeController {

    public static final String WELCOME_VIEW = "qy:welcome:view";
    public static final String WELCOME_EDIT = "qy:welcome:edit";

    @Autowired
    private WelcomeService welcomeService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = WELCOME_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,Long meetingId) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("meetingId",meetingId);
        return "welcome/welcomelist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = WELCOME_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model,Long meetingId) {
        Conds conds = new Conds();
        conds.equal("meetingId",meetingId);
        Sort sort = new Sort("create_time",OrderType.DESC);
        List<Welcome> list = welcomeService.fetchSearchByPage(conds,sort,0,0);
        if(list!=null){
            for(Welcome welcome:list){
                model.addAttribute("data", welcome);
            }
        }
        model.addAttribute("meetingId",meetingId);
        return "welcome/welcomeform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = WELCOME_EDIT)
    @RequestMapping(value = "/formData")
    @ResponseBody
    public JSONObject formData(Welcome welcome, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (welcome != null && welcome.getId() != null) {
                welcome.setUpdateBy(UserUtils.getUser().getId());
                welcomeService.update(welcome);
                rtnJson.put("errorNo", 0);
            } else {
                welcome.setNumber(codingruleUtils.getNumber(accountsId, Welcome.class.getName()));
                welcome.setAccountsId(accountsId);
                welcome.setDelFlag(false);
                welcome.setAccountsId(UserUtils.getmpaccounts(request));
                welcome.setCreateBy(UserUtils.getUser().getId());
                welcome.setUpdateBy(UserUtils.getUser().getId());
                welcomeService.save(welcome);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = WELCOME_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Welcome welcome, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(welcome.getNumber())) {
            conds.like("number", welcome.getNumber());
        }
        if (!StringUtils.isEmpty(welcome.getWelcome_titile())) {
            conds.like("welcome_titile", welcome.getWelcome_titile());
        }
        if(!StringUtils.isEmpty(welcome.getMeetingId())){
            conds.equal("meetingId",welcome.getMeetingId());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);
        List<Welcome> list = welcomeService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = welcomeService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = WELCOME_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            welcomeService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
