package com.cftech.showroom.explainer.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 展厅申请品牌大使
 *
 * @author lisw
 * @date: 2019-07-31 15:46
 */
@Data
public class Explainer implements Serializable {

    /* 主键id */
    private Long id;
    /*序号*/
    @ExportConfig(value = "序号", width = 100)
    private String  no;
    @ExportConfig(value = "品牌大使姓名", width = 100)
    private String name;
    /* 品牌大使邮箱 */
    @ExportConfig(value = "品牌大使邮箱", width = 100)
    private String email;

    @ExportConfig(value = "手机号码", width = 100)
    private String number;
    /* 品牌大使头像 */
    @ExportConfig(value = "品牌大使头像", width = 100,showLevel = 1)
    private String headImage;
    @ExportConfig(value = "品牌大使简介", width = 100)
    private String description;

    @ExportConfig(value = "排序值", width = 200)
    private String sort;
    /* 状态 */
    @ExportConfig(value = "状态(0:禁用 1:启用)", width = 200)
    private String status;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;

    /* 创建时间 */
    @ExportConfig(value = "创建时间", width = 200,showLevel = 1,dateFormat = "yyyy-MM-dd HH:mm")
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */

    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;



    public Explainer() {
        this.delFlag = false;
        this.status = "1";
    }

}