package com.cftech.common.commondept.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 通用申请单部门
 *
 * @author faye
 * @date: 2019-08-14 17:08
 */
@Data
public class CommonDepartment implements Serializable {

    /* 主键id */
    private Long id;
    /* 部门名称 */
    @ExportConfig(value = "部门名称", width = 100)
    private String name;
    /* 排序值 */
    @ExportConfig(value = "排序值", width = 100)
    private String sort;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    /**
     * 审批人ID
     */
    private Long approverId;

    /**
     * 所属单据
     */
    private Long typeform;

    public CommonDepartment() {
        this.delFlag = false;
        this.status = "0";
    }

}