package com.cftech.brand.apply.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 品牌申请
 *
 * @author faye
 * @date 2020/01/14
 */
@Data
public class BrandApply implements Serializable {

    /** 主键id */
    private Long id;

    /**
     * openId
     */
    private String openId;

    /** 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;

    /** 姓名 */
    @ExportConfig(value = "姓名", width = 100)
    private String name;

    /** 邮箱 */
    @ExportConfig(value = "邮箱", width = 100)
    private String email;

    /** 成本中心 */
    @ExportConfig(value = "成本中心", width = 100)
    private String costCenter;

    /** 部门id */
    private Long departmentId;

    /**
     * 直属领导姓名
     */
    @ExportConfig(value = "直属领导姓名", width = 100)
    private String lineManager;

    /** 直属领导邮箱 */
    @ExportConfig(value = "直属领导邮箱", width = 100)
    private String lineManagerEmail;

    /** 分类id */
    private Long categoryId;

    /** 需求说明/用途 */
    @ExportConfig(value = "说明需求用途", width = 100)
    private String requireSpecify;

    /** 是否制作实物 */
    @ExportConfig(value = "是否制作实物", width = 100)
    private String isMaterialObject;


    /** 期望交付日期 */
    @ExportConfig(value = "期望交付日期", width = 100)
    private Date deliveryDate;

    /** 其他备注 */
    @ExportConfig(value = "其他备注", width = 100)
    private String description;

    /**
     *legal entity
     */
    private String legalEntity;

  /*  *//** 预估数量 *//*
    @ExportConfig(value = "预估数量", width = 100)
    private Integer predictQuantity;*/

    /** 申请分配类别 0 仅设计 1仅制作 2设计和制作 */
    @ExportConfig(value = "申请分配类别", width = 100)
    private String distributionClass;

    /**
     * 设计人员id
     */
    private Long empId;


    /**
     * 联系人id
     */
    private Long contactEmpId;

    /** 供应商Id */
    private Long supplierId;

    /** 工时 */
    private Double manHour;

    /**
     * 预估工作量
     */
    private String estimatedWorkload;
    /**
     * 小时费率
     */
    private Double hourlyRate;

    /**
     * 预估内部费用
     */
    private Double estimateInternalCosts;

    /**
     * 预估外部费用
     */
    private Double estimateExternalCosts;

    /** 物料 */
    @ExportConfig(value = "物料", width = 100)
    private String materialDetail;

    /** 预估总费用 */
    private Double quotedPrice;

    /**
     * 拟交付日期
     */
    private Date intendedDeliveryDate;

    /** 申请状态 0待接单 1待申请人确认 2待审批 3审批通过 4关闭 5已完成 */
    @ExportConfig(value = "申请状态 0待接单 1待确认 2待审批 3审批通过 4关闭 5已完成 6已取消", width = 100)
    private String status;

    /** 所属的账号 */
    private Long accountsId;

    /** 删除标识 */
    private boolean delFlag;

    /** 创建时间 */
    private Date createTime;

    /** 更新时间 */
    private Date updateTime;


    /** 创建人 */
    private Long createBy;

    /** 更新人 */
    private Long updateBy;

    /**
     * 关闭订单理由
     */
    private String closeReason;

    /**
     * 实际交付日期
     */
    private Date actualDeliveryDate;

    /**
     * 内部费用
     */
    private double innerCost;

    /**
     * 外部费用
     */
    private double outerCost;

    /**
     * 总费用
     */
    private double totalCost;

    /**
     * 是否推送申请人评分
     */
    private String isScore;

    /*******管理员评分*********/


    /**
     * 设计质量评分
     */
    private String designQuanlityScore;

    /**
     *制作质量评分
     */
    private String makeQuanlityScore;

    /**
     * 意见反馈
     */
    private String managerFeedback;

    /**********管理员评分--end************/

    /*************申请人评分*****************/

    /**
     * 服务评分
     */
    private String serviceScore;

    /**
     * 意见反馈
     */
    private String feedback;

    /**
     * 审批人
     */
    private String auditId;

    /**
     * 管理员备注
     */
    private String managerRemark;

    /*************申请人评分--end*****************/

    /** 文件信息 **/

    /**
     * 文件名称
     */
    private String productName;

    /**
     * 文件类型
     */
    private String productFormat;

    /**
     * 文件标签
     */
    private String productLabel;

    /**
     * 文件存储前缀
     */
    private String filePrefix;

    public BrandApply() {
        this.delFlag = false;
        this.status = "0";
    }

}