package com.cftech.base.org.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.org.model.Qyuser;
import com.cftech.base.org.service.QyuserService;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.Constants;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/mobile/auth/qyuser")
public class MobileQyuserController {

    @Autowired
    private QyuserService qyuserService;


    @RequestMapping(value = "/getEmpList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getEmpList(Long storeId) {
        JSONObject obj = new JSONObject();
        Conds conds = new Conds();
        conds.equal("t.del_flag", Constants.DEL_FLAG_0);
        conds.equal("t.store_id", storeId);
        conds.equal("t.role", '2');
        List<Qyuser> datas = qyuserService.fetchSearchByPage(0L, conds, null, 0, 0);

        obj.put("errorNo", "0");
        obj.put("data", datas);

        return obj;
    }

    @RequestMapping(value = "/getEmpDetail", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getEmpDetail(Long employeeId) {
        JSONObject obj = new JSONObject();

        Qyuser qyuser = qyuserService.fetchById(employeeId);
        obj.put("errorNo", "0");
        obj.put("data", qyuser);

        return obj;
    }

    /**
     * 上传头像
     * @param qyuser 对象中只包含头像
     * @return
     */
    @RequestMapping(value = "/uploadAvatar", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject uploadAvatar(Qyuser qyuser) {
        JSONObject obj = new JSONObject();

        qyuserService.update(qyuser);
        obj.put("errorNo", "0");

        return obj;
    }
}
