package com.cftech.like.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by mubo 10/05/2017.
 */
@Data
public class LikeDto implements Serializable {
    /**
     * id
     */
    private Long id;

    /**
     * 服务号或企业号标识
     */

    private Long accountsId;
    /**
     * 被点赞模块枚举
     */
    private String moduleType;
    /**
     * 点赞实体主键
     */
    @ExportConfig(value = "实体内容", width = 100)
    private String entitycontent;

    /**
     * 操作类型枚举（点赞/取消点赞/踩/取消踩）
     */
    @ExportConfig(value = "操作类型", width = 100)
    private String type;

    /**
     * 点赞人
     */
    private String userId;

    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建时间导出字段
     * */
    @ExportConfig(value = "点赞时间", width = 200)
    private String createTimeExport;

    /**
     * 记录时效性
     */
    private Boolean delFlag;

    /**
     * 模块名称
     */
    @ExportConfig(value = "模块名称", width = 100, showLevel = 1)
    private String moduleName;

    /**
     * 实体名称
     */
    private String entityName;

    /**
     * 点赞人姓名
     */
    @ExportConfig(value = "点赞人姓名", width = 100)
    private String userName;

    public LikeDto() {
        this.delFlag = false;
    }
}