package com.cftech.cos.config.cosconfig.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.cos.config.cosconfig.model.Cosconfig;
import com.cftech.cos.config.cosconfig.service.CosconfigService;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * 云存储设置Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String COSCONFIG_VIEW = "qy:cosconfig:view"
 * 查看:public static final String COSCONFIG_EDIT = "qy:cosconfig:edit"
 * </p>
 * @author Neil
 * @date: 2017-05-02 16:35
 */
@Slf4j
@Controller
@RequestMapping("/a/cosconfig")
public class CosconfigController {

    public static final String COSCONFIG_VIEW = "qy:cosconfig:view";
    public static final String COSCONFIG_EDIT = "qy:cosconfig:edit";

    @Autowired
    private CosconfigService cosconfigService;


    //列表页面
    @RequiresPermissions(value = COSCONFIG_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long userId = UserUtils.getUser().getId();
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("create_by", userId);

        List<Cosconfig> cosconfigList = cosconfigService.fetchSearchByPage(conds, null, 0,0);
        for (Cosconfig cosconfig : cosconfigList) {
            model.addAttribute(cosconfig.getCosType(), true);
        }
        return "cosconfig/cosconfiglist";
    }

    //qcloudconfig页面
    @RequiresPermissions(value = COSCONFIG_EDIT)
    @RequestMapping("/qcloudconfig")
    public String qcloudconfig(HttpServletRequest request, Model model) {
        Long userId = UserUtils.getUser().getId();
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("create_by", userId);
        conds.equal("cos_type", "qcloud");

        Cosconfig cosconfig = cosconfigService.fetchSearchByConds(conds);
        if (cosconfig != null) {
            model.addAttribute("data", cosconfig);
        }
        return "cosconfig/qcloudconfigform";
    }

    //qcloudconfig页面
    @RequiresPermissions(value = COSCONFIG_EDIT)
    @RequestMapping("/alicloudconfig")
    public String alicloudconfig(HttpServletRequest request, Model model) {
        Long userId = UserUtils.getUser().getId();
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("create_by", userId);
        conds.equal("cos_type", "ali");

        Cosconfig cosconfig = cosconfigService.fetchSearchByConds(conds);
        if (cosconfig != null) {
            model.addAttribute("data", cosconfig);
        }
        return "cosconfig/aliconfigform";
    }


    //qcloudconfig页面
    @RequiresPermissions(value = COSCONFIG_EDIT)
    @RequestMapping("/qiniucloudconfig")
    public String qiniucloudconfig(HttpServletRequest request, Model model) {
        Long userId = UserUtils.getUser().getId();
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("create_by", userId);
        conds.equal("cos_type", "qiniu");

        Cosconfig cosconfig = cosconfigService.fetchSearchByConds(conds);
        if (cosconfig != null) {
            model.addAttribute("data", cosconfig);
        }
        return "cosconfig/qiniuconfigform";
    }



    //提交数据（新增、修改）
    @RequiresPermissions(value = COSCONFIG_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Cosconfig cosconfig, Model model, HttpServletRequest request) {
        JSONObject rtnJson = new JSONObject();
        try {
            if (cosconfig != null && cosconfig.getId() != null) {
                cosconfig.setUpdateBy(UserUtils.getUser().getId());
                cosconfigService.update(cosconfig);
                rtnJson.put("errorNo", 0);
            } else {
                cosconfig.setDelFlag(false);
                cosconfig.setCreateBy(UserUtils.getUser().getId());
                cosconfig.setUpdateBy(UserUtils.getUser().getId());
                cosconfigService.save(cosconfig);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = COSCONFIG_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Cosconfig cosconfig, HttpServletRequest request) {
        Long userId = UserUtils.getUser().getId();
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("create_by", userId);
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Cosconfig> list = cosconfigService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = cosconfigService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    @RequiresPermissions(value = COSCONFIG_VIEW)
    @RequestMapping("/coslist")
    @ResponseBody
    public JSONObject coslist(HttpServletRequest request) {
        Long userId = UserUtils.getUser().getId();
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        List<Cosconfig> cosconfigList = cosconfigService.fetchSearchByPage(conds, null, 0, 0);
        JSONObject retJson = new JSONObject();
        retJson.put("errorNo", "0");
        JSONArray arr = new JSONArray();
        JSONObject item = new JSONObject();
//        item.put("cosId", 0);
//        item.put("cosType", "local");
//        item.put("cosName", "本地");
//        arr.add(item);
        for (Cosconfig cosconfig : cosconfigList) {
            item = new JSONObject();
            item.put("cosId", cosconfig.getId());
            String cosType = cosconfig.getCosType();
            item.put("cosType", cosType);
            if (cosType.equals("qcloud")) {
                item.put("cosName", "腾讯COS");
            } else if (cosType.equals("ali")) {
                item.put("cosName", "阿里OSS");
            } else if (cosType.equals("qiniu")) {
                item.put("cosName", "七牛云");
            }

            arr.add(item);
        }

        retJson.put("data", arr);
        return retJson;
    }

    //删除数据
    @RequiresPermissions(value = COSCONFIG_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String type) {
        JSONObject rtnJosn = new JSONObject();

        Long userId = UserUtils.getUser().getId();
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("create_by", userId);
        conds.equal("cos_type", type);

        Cosconfig cosconfig = cosconfigService.fetchSearchByConds(conds);
        if (cosconfig == null) {
            rtnJosn.put("errorNo", 1);
        } else {
            try {
                cosconfigService.delete(cosconfig.getId());
                rtnJosn.put("errorNo", 0);
            } catch (Exception e) {
                rtnJosn.put("errorNo", 1);
            }
        }
        return rtnJosn;
    }

}
